﻿using System.Linq;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;

namespace BMS.VistaIntegration.Via.Commands.Maps
{
    public class ViaOrderMap : EntityMap<Order>
    {
        public override string Location
        {
            get
            {
                return "OR(100,";
            }
        }

        public override Order NewEntity(string ien)
        {
            return new Order()
            {
                IEN = ien,
                OrderNumber = ien,
                OrderOrderableItemIds = new System.Collections.Generic.List<string>(),
            };
        }

        public override string File
        {
            get
            {
                return "100";
            }
        }

        protected override void MapFields()
        {
            MapDateTime(".8", (m, d) => { });
            MapPointerToFile<OrderStatus>("5", (m, s) => m.StatusId = s, (m, s) => m.OrderStatus = s);
            MapPointerToFile<Patient>(".02", (m, s) => m.PatientId = s.Split(';').First(), (m, s) => m.Patient = s);
            MapPointerToFile<HospitalLocation>("6", (m, s) => m.HospitalLocationId = s.Split(';').First(), (m, s) => m.HospitalLocation = s);
        }
    }
}
